Rem
Rem $Header: rdf_model_data.sql 12-may-2005.07:56:06 nalexand Exp $
Rem
Rem rdf_model_data.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rdf_model_data.sql - data for DEMO rdf_network
Rem
Rem    DESCRIPTION
Rem      Sample data for DEMO
Rem
Rem    NOTES
Rem      sdo_rdf_triple TYPE must exist
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nalexand    05/12/05 - add ID 28 to family demo 
Rem    nalexand    05/05/05 - update create_rdf_model() call 
Rem    nalexand    04/25/05 - update demo files. 
Rem    echong      04/25/05 - add more info to the family tree 
Rem    geadon      04/21/05 - simply URIs for demo 
Rem    echong      04/21/05 - add demo for user-defined rules 
Rem    nalexand    01/05/05 - turn escape off before on; 
Rem    nalexand    12/02/04 - turn escape off, it is affecting typed literals 
Rem    sravada     11/10/04 - 
Rem    nalexand    11/05/04 - 
Rem    nalexand    09/20/04 - new collections
Rem    nalexand    07/14/04 - use host variable to load collections
Rem    nalexand    07/08/04 - add nsu, nature2, and jobs
Rem    nalexand    06/22/04 - change to sdo_rdf_triple_s
Rem    nalexand    04/23/04 - updated for new signature
Rem    nalexand    04/09/04 - nalexand_rdf0401 
Rem    nalexand    04/09/04 - Created
Rem


--MODEL 1 --

SET SERVEROUTPUT ON;
SET ESCAPE OFF;
SET ESCAPE ^;

CREATE TABLE nature_rdf_data (id NUMBER, triple SDO_RDF_TRIPLE_S);
-- @create_rdf_model.sql
execute  sdo_rdf.create_rdf_model('nature', 'nature_rdf_data', 'triple');

PROMPT Inserting MODEL_1 RDF Statements...

-- statement 1 --
INSERT INTO nature_rdf_data VALUES (1,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article1',
'http://purl.org/dc/elements/1.1/title','An article about XYZ'));

-- statement 2 --
INSERT INTO nature_rdf_data VALUES (2,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article1',
'http://purl.org/dc/elements/1.1/creator','Jane Doe'));

--statement 3 --
INSERT INTO nature_rdf_data VALUES (3,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article1',
'http://purl.org/dc/terms/references','http://www.nature.com/nature/article3'));

--statement 4 --
INSERT INTO nature_rdf_data VALUES (4,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article1',
'http://purl.org/dc/terms/references','http://www.nature.com/nature/article2'));

--statement 5 --
INSERT INTO nature_rdf_data VALUES (5,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article2',
'http://purl.org/dc/elements/1.1/title','A review of ABC'));

--statement 6 --
INSERT INTO nature_rdf_data VALUES (6,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article2',
'http://purl.org/dc/elements/1.1/creator','Joe Bloggs'));

--statement 7 --
INSERT INTO nature_rdf_data VALUES (7,
sdo_rdf_triple_s ('nature','http://www.nature.com/nature/article2',
'http://purl.org/dc/terms/references','http://www.nature.com/nature/article3'));

COMMIT;


-- MODEL 2 Personal Information Management (PIM) application --
CREATE TABLE personal_info (ssn NUMBER, rdf_data SDO_RDF_TRIPLE_S);

execute sdo_rdf.create_rdf_model('pim', 'personal_info', 'rdf_data');

PROMPT Inserting MODEL_2 RDF Statements...

INSERT INTO personal_info VALUES (111223333,
sdo_rdf_triple_s ('pim','urn:TV:AnimatedCharacters:FredFlintstone','urn:TV:AnimatedRelationships:wife',
'urn:TV:AnimatedCharacters:WilmaFlintstone'));

INSERT INTO personal_info VALUES (111223333,
sdo_rdf_triple_s ('pim','urn:TV:AnimatedCharacters:FredFlintstone','urn:TV:AnimatedRelationships:friend',
'urn:TV:AnimatedCharacters:Barney'));

INSERT INTO personal_info VALUES (111223333,
sdo_rdf_triple_s ('pim','urn:TV:AnimatedCharacters:FredFlintstone','urn:TV:AnimatedRelationships:pet',
'urn:TV:AnimatedCharacters:Dino'));

COMMIT;


-- MODEL 3 Bookstore  application --
CREATE TABLE book_reviews (isbn VARCHAR2(30), rdf_data SDO_RDF_TRIPLE_S);

execute sdo_rdf.create_rdf_model('bookstore', 'book_reviews', 'rdf_data');

PROMPT Inserting MODEL_3 RDF Statements...

INSERT INTO book_reviews VALUES ('ISBN-22-33-1234',
sdo_rdf_triple_s ('bookstore','urn:TV:AnimatedCharacters:Barnie','urn:TV:AnimatedRelationships:recommends',
'urn:TV:AnimatedRanking:VeryHighly'));

INSERT INTO book_reviews VALUES ('ISBN-22-33-1234',
sdo_rdf_triple_s ('bookstore','urn:TV:AnimatedCharacters:WilmaFlintstone','urn:TV:AnimatedRelationships:recommends',
'urn:TV:AnimatedRanking:Highly'));

COMMIT;


-- MODEL 4 --
CREATE TABLE nsu (triple SDO_RDF_TRIPLE_S);

execute sdo_rdf.create_rdf_model('nsu', 'nsu', 'triple');

@nsu.sql

-- MODEL 5 --
CREATE TABLE nature (triple SDO_RDF_TRIPLE_S);

execute sdo_rdf.create_rdf_model('nature2', 'nature', 'triple');

@nature.sql

-- MODEL 6 --
CREATE TABLE jobs (triple SDO_RDF_TRIPLE_S);

execute sdo_rdf.create_rdf_model('jobs', 'jobs', 'triple');

@jobs.sql

-- MODEL 7 (user-defined rules) --
/*
   Represents the following family tree:

               John    Janice
                   \  /
                    \/
                    /\
                   /  \
     Sammy    Suzie    Matt    Martha
          \  /             \  /
           \/               \/
           /\               /\
          /  \             /  \
     Cathy    Jack(M)   Tom(M) Cindy(F)
     |          ^
     |          |
     +-sisterOf-+             

*/

CREATE TABLE family_rdf_data (id NUMBER, triple SDO_RDF_TRIPLE_S);

execute sdo_rdf.create_rdf_model('family', 'family_rdf_data', 'triple');

INSERT INTO family_rdf_data VALUES (1, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/John', 
'http://www.example.org/family/fatherOf', 
'http://www.example.org/family/Suzie'));

INSERT INTO family_rdf_data VALUES (2, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/John', 
'http://www.example.org/family/fatherOf', 
'http://www.example.org/family/Matt'));

INSERT INTO family_rdf_data VALUES (3, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Janice', 
'http://www.example.org/family/motherOf', 
'http://www.example.org/family/Suzie'));

INSERT INTO family_rdf_data VALUES (4, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Janice', 
'http://www.example.org/family/motherOf', 
'http://www.example.org/family/Matt'));

INSERT INTO family_rdf_data VALUES (5, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Sammy', 
'http://www.example.org/family/fatherOf', 
'http://www.example.org/family/Cathy'));

INSERT INTO family_rdf_data VALUES (6, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Sammy', 
'http://www.example.org/family/fatherOf', 
'http://www.example.org/family/Jack'));

INSERT INTO family_rdf_data VALUES (7, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Suzie', 
'http://www.example.org/family/motherOf', 
'http://www.example.org/family/Cathy'));

INSERT INTO family_rdf_data VALUES (8, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Suzie', 
'http://www.example.org/family/motherOf', 
'http://www.example.org/family/Jack'));

INSERT INTO family_rdf_data VALUES (9, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Matt', 
'http://www.example.org/family/fatherOf', 
'http://www.example.org/family/Tom'));

INSERT INTO family_rdf_data VALUES (10, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Matt', 
'http://www.example.org/family/fatherOf', 
'http://www.example.org/family/Cindy'));

INSERT INTO family_rdf_data VALUES (11, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Martha', 
'http://www.example.org/family/motherOf', 
'http://www.example.org/family/Tom'));

INSERT INTO family_rdf_data VALUES (12, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Martha', 
'http://www.example.org/family/motherOf', 
'http://www.example.org/family/Cindy'));

INSERT INTO family_rdf_data VALUES (13, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Cathy', 
'http://www.example.org/family/sisterOf', 
'http://www.example.org/family/Jack'));

INSERT INTO family_rdf_data VALUES (14, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Jack', 
'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
'http://www.example.org/family/Male'));

INSERT INTO family_rdf_data VALUES (15, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Tom', 
'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
'http://www.example.org/family/Male'));

INSERT INTO family_rdf_data VALUES (16, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Cindy', 
'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
'http://www.example.org/family/Female'));

INSERT INTO family_rdf_data VALUES (17, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Person', 
'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
'http://www.w3.org/2000/01/rdf-schema#Class'));

INSERT INTO family_rdf_data VALUES (18, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Male', 
'http://www.w3.org/2000/01/rdf-schema#subClassOf',
'http://www.example.org/family/Person'));

INSERT INTO family_rdf_data VALUES (19, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Female', 
'http://www.w3.org/2000/01/rdf-schema#subClassOf',
'http://www.example.org/family/Person'));

INSERT INTO family_rdf_data VALUES (20, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/siblingOf', 
'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
'http://www.w3.org/1999/02/22-rdf-syntax-ns#Property'));

INSERT INTO family_rdf_data VALUES (21, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/parentOf', 
'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
'http://www.w3.org/1999/02/22-rdf-syntax-ns#Property'));

INSERT INTO family_rdf_data VALUES (22, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/brotherOf', 
'http://www.w3.org/2000/01/rdf-schema#subPropertyOf',
'http://www.example.org/family/siblingOf'));

INSERT INTO family_rdf_data VALUES (23, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/sisterOf', 
'http://www.w3.org/2000/01/rdf-schema#subPropertyOf',
'http://www.example.org/family/siblingOf'));

INSERT INTO family_rdf_data VALUES (24, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/brotherOf', 
'http://www.w3.org/2000/01/rdf-schema#domain',
'http://www.example.org/family/Male'));

INSERT INTO family_rdf_data VALUES (25, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/sisterOf', 
'http://www.w3.org/2000/01/rdf-schema#domain',
'http://www.example.org/family/Female'));

INSERT INTO family_rdf_data VALUES (26, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/fatherOf', 
'http://www.w3.org/2000/01/rdf-schema#subPropertyOf',
'http://www.example.org/family/parentOf'));

INSERT INTO family_rdf_data VALUES (27, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/motherOf', 
'http://www.w3.org/2000/01/rdf-schema#subPropertyOf',
'http://www.example.org/family/parentOf'));

INSERT INTO family_rdf_data VALUES (28, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/fatherOf', 
'http://www.w3.org/2000/01/rdf-schema#domain',
'http://www.example.org/family/Male'));

INSERT INTO family_rdf_data VALUES (29, 
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/motherOf', 
'http://www.w3.org/2000/01/rdf-schema#domain',
'http://www.example.org/family/Female'));

SET ESCAPE OFF;

INSERT INTO family_rdf_data VALUES (30,
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Cathy', 
'http://www.example.org/family/height',
'"5.8"^^xsd:decimal'));

INSERT INTO family_rdf_data VALUES (31,
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Jack', 
'http://www.example.org/family/height',
'"6"^^xsd:integer'));

INSERT INTO family_rdf_data VALUES (32,
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Tom', 
'http://www.example.org/family/height',
'"05.75"^^xsd:decimal'));

INSERT INTO family_rdf_data VALUES (33,
SDO_RDF_TRIPLE_S('family', 
'http://www.example.org/family/Cindy', 
'http://www.example.org/family/height',
'"06.00"^^xsd:decimal'));

commit;
